unit Prop;

interface

uses
    SysUtils,
    WinTypes,
    WinProcs,
    Classes,
    Graphics,
    Forms,
    Controls,
    Buttons,
    Dialogs,
    Grids,
    StdCtrls,
    ExtCtrls,
    Nwtools,
    Nwlib,
    NwProp;

type
  TwinProp = class(TForm)
    listboxPanel: TPanel;
    buttonPanel: TPanel;
    bCancel: TBitBtn;
    bAdd: TBitBtn;
    bEdit: TBitBtn;
    bDelete: TBitBtn;
    objGrid: TStringGrid;
    bRename: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure bAddClick(Sender: TObject);
    procedure bRenameClick(Sender: TObject);
    procedure bDeleteClick(Sender: TObject);
    procedure bEditClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  winProp: TwinProp;

implementation

{$R *.DFM}

uses
  objEdit ;

procedure TwinProp.FormCreate(Sender: TObject);
  var
    objList : TStringList;
    nloop   : word       ;
    ncursor : TCursor    ;
  begin
    ncursor := screen.cursor ;
    screen.cursor := crHourglass ;
    autoGridLineHeight(objGrid) ;
    objList := getBinderyList(getPrimaryServerID,nw_user) ;
    try
      { Add Users, Groups, PrintQs and PrintServers to Grid }
      objGrid.rowCount     := 1 ;
      objGrid.cells[0,0]   := 'Object Name' ;
      objGrid.cells[1,0]   := 'Object Type' ;
      objList.sort ;
      for nloop := 1 to objList.count do begin
        objGrid.rowCount := (objGrid.rowCount+1) ;
        objGrid.cells[0,objGrid.rowCount-1] := objList[nloop-1] ;
        objGrid.cells[1,objGrid.rowCount-1] := 'User' ;
      end;
      objList.clear ;
      objList := getBinderyList(getPrimaryServerID,nw_group) ;
      objList.sort ;
      for nloop := 1 to objList.count do begin
        objGrid.rowCount := (objGrid.rowCount+1) ;
        objGrid.cells[0,objGrid.rowCount-1] := objList[nloop-1] ;
        objGrid.cells[1,objGrid.rowCount-1] := 'Group' ;
      end;
      objList.clear ;
      objList := getBinderyList(getPrimaryServerID,nw_printQ) ;
      objList.sort ;
      for nloop := 1 to objList.count do begin
        objGrid.rowCount := (objGrid.rowCount+1) ;
        objGrid.cells[0,objGrid.rowCount-1] := objList[nloop-1] ;
        objGrid.cells[1,objGrid.rowCount-1] := 'Print Queue' ;
      end;
      objList.clear ;
      objList := getBinderyList(getPrimaryServerID,nw_printServer) ;
      objList.sort ;
      for nloop := 1 to objList.count do begin
        objGrid.rowCount := (objGrid.rowCount+1) ;
        objGrid.cells[0,objGrid.rowCount-1] := objList[nloop-1] ;
        objGrid.cells[1,objGrid.rowCount-1] := 'Print Server' ;
      end;
    finally
      if (objGrid.rowCount > 1) then
        objGrid.fixedRows := 1;
      objList.free ;
      screen.cursor := ncursor ;
    end;
  end;

procedure TwinProp.bAddClick(Sender: TObject);
  begin
    try
      application.createForm(TWinObjEdit,winObjEdit);
      winObjEdit.objName.text  := ''   ;
      winObjEdit.fullName.text := ''   ;
      winObjEdit.password.text := ''   ;
      winObjEdit.objType.itemIndex := 0 ;
      winObjEdit.caption       := 'Creating New Object' ;
      winObjEdit.creating      := True ;
      winObjEdit.showModal ;
    finally
      winObjEdit.free ;
    end;
  end;

procedure TwinProp.bRenameClick(Sender: TObject);
  var
    ctext : string ;
  begin
    ctext := objGrid.cells[0,objGrid.row] ;
    if inputQuery('Renaming Object: ' + ctext ,
                  'Type New Name:',
                  ctext) then
      begin
        if renameObject(getPrimaryServerID,
                        objGrid.cells[0,objGrid.row],
                        ctext,
                        getObjType(0,objGrid.cells[0,objGrid.row])) then
          objGrid.cells[0,objGrid.row] := upperCase(ctext)
        else
          alertBox('Error Renaming Object;;Check Access Rights and Try Again') ;
      end;
  end;

procedure TwinProp.bDeleteClick(Sender: TObject);
  var
    ctemp : string ;
  begin
    ctemp := objGrid.cells[0,objGrid.row] ;
    if YesNoBox(ctemp + ';Deleting Object;;Are You Sure?') then
      begin
        if deleteObject(0,ctemp) then
          begin
            objGrid.cells[0,objGrid.row] := '<Deleted>' ;
            objGrid.cells[1,objGrid.row] := '' ;
            okBox(ctemp + ';Object Deleted Successfully') ;
          end
        else
          alertBox(ctemp + ';Error Deleting Object!') ;
      end;
  end;

procedure TwinProp.bEditClick(Sender: TObject);
  var
    ctemp : string ;
    ncursor : TCursor ;
  begin
    ncursor := screen.cursor ;
    screen.cursor := crHourglass ;
    ctemp := objGrid.cells[0,objGrid.row] ;
    try
      application.createForm(TWinObjEdit,winObjEdit);
      winObjEdit.objName.text  := ctemp   ;
      winObjEdit.fullName.text := fullName(0,ctemp) ;
      winObjEdit.password.text := ''   ;
      winObjEdit.caption       := 'Modifying Object' ;
      winObjEdit.creating      := False ;
      case getObjType(0,ctemp) of
        nw_user        : winObjEdit.objType.itemIndex := 0 ;
        nw_group       : winObjEdit.objType.itemIndex := 1 ;
        nw_printQ      : winObjEdit.objType.itemIndex := 2 ;
        nw_printServer : winObjEdit.objType.itemIndex := 3 ;
      end;
      { need to set Duration, Read and Write itemIndexes }
      screen.cursor := nCursor ;
      winObjEdit.showModal ;
    finally
      winObjEdit.free ;
      screen.cursor := nCursor ;
    end;
  end;

end.
